<?php
declare(strict_types=1);
session_start();

require __DIR__ . '/../lib/util.php';
$cfg = al_load_config();
$state = al_load_state($cfg);

$action = $_GET['a'] ?? '';
if ($action === 'logout') {
  session_destroy();
  header('Location: index.php');
  exit;
}

$auth = $_SESSION['autolink_client_admin'] ?? false;

if (!$auth) {
  $err = '';
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = (string)($_POST['u'] ?? '');
    $p = (string)($_POST['p'] ?? '');
    if ($u === ($cfg['admin']['username'] ?? 'admin') && password_verify($p, $cfg['admin']['password_hash'])) {
      $_SESSION['autolink_client_admin'] = true;
      header('Location: index.php');
      exit;
    }
    $err = 'Invalid login';
  }
  ?>
  <!doctype html><html><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Auto-Linker Admin</title>
  <style>body{font-family:system-ui;margin:40px auto;max-width:540px;padding:0 14px}input{width:100%;padding:10px;margin:6px 0 12px}button{padding:10px 14px;border-radius:10px;border:1px solid #111;background:#111;color:#fff;font-weight:800}</style>
  </head><body>
  <h1>Auto-Linker Admin</h1>
  <?php if($err): ?><div style="background:#ffecec;border:1px solid #ffb3b3;padding:10px;border-radius:10px"><?=al_h($err)?></div><?php endif; ?>
  <form method="post">
    <label>Username</label><input name="u" value="">
    <label>Password</label><input name="p" type="password" value="">
    <button>Login</button>
  </form>
  </body></html>
  <?php
  exit;
}

$msg = '';
$err = '';

if ($action === 'change_pass' && $_SERVER['REQUEST_METHOD']==='POST') {
  $p1 = (string)($_POST['p1'] ?? '');
  $p2 = (string)($_POST['p2'] ?? '');
  if (strlen($p1) < 10) $err = 'Password must be at least 10 characters.';
  elseif ($p1 !== $p2) $err = 'Passwords do not match.';
  else {
    $cfg_file = __DIR__ . '/../config.php';
    $cfg['admin']['password_hash'] = password_hash($p1, PASSWORD_DEFAULT);
    file_put_contents($cfg_file, "<?php
return " . var_export($cfg, true) . ";
");
    $msg = 'Password changed.';
  }
}

if ($action === 'refresh') {
  if (!empty($state['listing']['listing_id'])) {
    $id = (int)$state['listing']['listing_id'];
    $r = al_http_get($cfg['network_api'] . '?r=listing&id=' . $id);

    if ($r['ok'] && $r['status'] >= 200 && $r['status'] < 300) {
      $j = json_decode($r['body'] ?: '{}', true);
      if (is_array($j) && !empty($j['listing'])) {
        $state['listing']['status'] = $j['listing']['status'] ?? ($state['listing']['status'] ?? '');
        al_save_state($cfg, $state);

        // Clear cache so public page updates immediately
        $cacheDir = __DIR__ . '/../cache';
        if (is_dir($cacheDir)) {
          foreach (glob($cacheDir . '/*.json') as $f) { @unlink($f); }
        }

        $msg = 'Status refreshed from network: ' . ($state['listing']['status'] ?? '');
      }
    } else {
      $err = 'Could not refresh status from network (HTTP ' . ($r['status'] ?? 0) . ').';
    }
  } else {
    $err = 'Nothing to refresh (not registered yet).';
  }
}


if ($action === 'register' && $_SERVER['REQUEST_METHOD']==='POST') {
  $site_url = al_normalize_url((string)($_POST['site_url'] ?? ''));
  $name = trim((string)($_POST['name'] ?? ''));
  $description = trim((string)($_POST['description'] ?? ''));
  $category_id = (int)($_POST['category_id'] ?? 0);
  $backlink_check_url = al_normalize_url((string)($_POST['backlink_check_url'] ?? $site_url));
  $verify_check_url = al_normalize_url((string)($_POST['verify_check_url'] ?? $site_url));

  if ($site_url === '' || $name === '' || $description === '' || $category_id <= 0) {
    $err = 'Please fill out all fields.';
  } else {
    $resp = al_http_json($cfg['network_api'] . '?r=register', [
      'site_url'=>$site_url,
      'name'=>$name,
      'description'=>$description,
      'category_id'=>$category_id,
      'backlink_check_url'=>$backlink_check_url,
      'verify_check_url'=>$verify_check_url,
    ]);

    if (!$resp['ok']) {
      $err = 'Register failed (HTTP ' . $resp['status'] . '): ' . ($resp['data']['error'] ?? 'unknown');
    } else {
      $state['listing'] = $resp['data'];
      $state['site'] = [
        'site_url'=>$site_url,
        'name'=>$name,
        'description'=>$description,
        'category_id'=>$category_id,
        'backlink_check_url'=>$backlink_check_url,
        'verify_check_url'=>$verify_check_url,
      ];
      al_save_state($cfg, $state);
      $msg = 'Registered. Follow the verification + backlink steps below.';
    }
  }
}

$cats = al_http_get($cfg['network_api'] . '?r=categories');
$categories = [];
if ($cats['ok']) {
  $j = json_decode($cats['body'] ?: '{}', true);
  if (is_array($j) && !empty($j['categories'])) $categories = $j['categories'];
}

$listing = $state['listing'] ?? null;

?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Auto-Linker Admin</title>
  <style>
    body{font-family:system-ui;background:#0b0d10;color:#e7e7e7;margin:0}
    a{color:#a7d7ff;text-decoration:none}
    .wrap{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#0f131a;border:1px solid #1f2a3a;border-radius:16px;padding:14px;margin-top:12px}
    input,textarea,select{width:100%;padding:10px;border-radius:12px;border:1px solid #263548;background:#0f131a;color:#e7e7e7}
    textarea{min-height:90px;resize:vertical}
    .row{display:grid;grid-template-columns:1fr;gap:10px}
    @media(min-width:900px){.row{grid-template-columns:1fr 1fr}}
    button{padding:10px 14px;border-radius:12px;border:1px solid #2b3b53;background:#142031;color:#fff;font-weight:800;cursor:pointer}
    .pill{display:inline-block;border:1px solid #243349;border-radius:999px;padding:6px 10px;font-size:13px;color:#bcd0e5}
    .muted{color:#9aa7b6}
    pre{white-space:pre-wrap;background:#0b0d10;border:1px solid #1f2a3a;border-radius:12px;padding:12px;overflow:auto}
    .ok{background:#ecffef;border:1px solid #9be2a6;color:#0d3b16;padding:10px;border-radius:12px}
    .err{background:#ffecec;border:1px solid #ffb3b3;color:#5b0d0d;padding:10px;border-radius:12px}
  </style>
</head>
<body>
  <div class="wrap">
    <div style="display:flex;justify-content:space-between;align-items:center;gap:12px">
      <h1 style="margin:0">Auto-Linker Admin</h1>
      <div style="display:flex;gap:10px;flex-wrap:wrap;justify-content:flex-end">
        <a class="pill" href="../">Open Public Page</a>
        <a class="pill" href="?a=logout">Logout</a>
      </div>
    </div>

    <?php if($msg): ?><div class="card ok"><?=al_h($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="card err"><?=al_h($err)?></div><?php endif; ?>

    <div class="card">
      <h2 style="margin:0 0 8px 0">1) Register your site</h2>
      <form method="post" action="?a=register">
        <div class="row">
          <div>
            <label>Site URL (homepage)</label>
            <input name="site_url" value="<?=al_h($state['site']['site_url'] ?? '')?>" placeholder="https://example.com/">
          </div>
          <div>
            <label>Category</label>
            <select name="category_id">
              <option value="0">Select category</option>
              <?php foreach($categories as $c): ?>
                <option value="<?= (int)$c['id'] ?>" <?= ((int)($state['site']['category_id'] ?? 0) === (int)$c['id'])?'selected':'' ?>>
                  <?=al_h($c['name'])?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>

        <div class="row">
          <div>
            <label>Site Name</label>
            <input name="name" value="<?=al_h($state['site']['name'] ?? '')?>" placeholder="My Site Name">
          </div>
          <div>
            <label>Backlink check URL (where you will place the backlink)</label>
            <input name="backlink_check_url" value="<?=al_h($state['site']['backlink_check_url'] ?? '')?>" placeholder="https://example.com/ (or a links page)">
          </div>
        </div>

        <label>Description</label>
        <textarea name="description" placeholder="Short description (max ~280 chars)"><?=al_h($state['site']['description'] ?? '')?></textarea>

        <label>Verification check URL (page that contains the meta tag if you use meta method)</label>
        <input name="verify_check_url" value="<?=al_h($state['site']['verify_check_url'] ?? '')?>" placeholder="Usually your homepage">

        <div style="margin-top:10px"><button>Register</button></div>
      </form>
    </div>

    <div class="card">
      <h2 style="margin:0 0 8px 0">2) Verification + backlink (required)</h2>
        
      <?php if(!$listing || empty($listing['listing_id'])): ?>
        <div class="muted">Register first to receive your unique Listing ID and verification token.</div>
      <?php else: ?>
        <div class="row">
          <div>
            <div class="pill">Listing ID: <?= (int)$listing['listing_id'] ?></div>
            <div class="pill">Status: <?=al_h($listing['status'] ?? '')?></div>
          <a class="pill" href="?a=refresh" style="background:#142031">Refresh Status</a>

          </div>
          <div class="muted" style="text-align:right">
            Network: <a href="<?=al_h($cfg['network_base'])?>" target="_blank" rel="noopener"><?=al_h($cfg['network_base'])?></a>
          </div>
        </div>

        <h3 style="margin:14px 0 6px 0">Verification (recommended: .well-known file)</h3>
        <div class="muted">Create this file on your site:</div>
        <pre><?=al_h($listing['verify_methods']['well_known']['path'] ?? '/.well-known/mybtc-autolink.txt')?></pre>
        <div class="muted">File contents must be exactly:</div>
        <pre><?=al_h($listing['verify_methods']['well_known']['content'] ?? '')?></pre>

        <div class="muted" style="margin-top:10px">Alternative: add this meta tag on the page you set as "Verification check URL":</div>
        <pre><?=al_h($listing['verify_methods']['meta']['html'] ?? '')?></pre>

        <h3 style="margin:14px 0 6px 0">Backlink (must be visible + exact anchor text)</h3>
        <div class="muted">You must place a visible link on your site (no display:none / hidden) with anchor text containing:</div>
        <pre>MyBTC.World Auto-Linker</pre>

        <div class="muted">Your required backlink URL (must include your ID):</div>
        <pre><?=al_h($listing['backlink']['required_url'] ?? '')?></pre>

        <div class="muted">Recommended HTML snippet:</div>
        <pre><?=al_h($listing['backlink']['code'] ?? '')?></pre>

        <div class="muted" style="margin-top:10px">After you add verification + backlink, the network checker will activate your listing automatically (usually within the next scheduled check).</div>
      <?php endif; ?>
    </div>

    <div class="card">
      <h2 style="margin:0 0 8px 0">3) Change admin password</h2>
      <form method="post" action="?a=change_pass">
        <div class="row">
          <div><input type="password" name="p1" placeholder="New password (>=10 chars)"></div>
          <div><input type="password" name="p2" placeholder="Confirm new password"></div>
        </div>
        <div style="margin-top:10px"><button>Save Password</button></div>
      </form>
    </div>

  </div>
</body>
</html>
