<?php
declare(strict_types=1);
require __DIR__ . '/lib/util.php';

$cfg = al_load_config();
$cacheDir = __DIR__ . '/cache';
if (!is_dir($cacheDir)) @mkdir($cacheDir, 0775, true);

$q = trim((string)($_GET['q'] ?? ''));
$cat = (int)($_GET['category_id'] ?? 0);
$page = max(1, (int)($_GET['page'] ?? 1));
$per = 20;

$catsCache = $cacheDir . '/categories.json';
$listCache = $cacheDir . '/listings_' . md5(json_encode([$q,$cat,$page,$per])) . '.json';

$ttl = (int)($cfg['cache_ttl'] ?? 3600);

function cache_get(string $path, int $ttl): ?array {
  if (!file_exists($path)) return null;
  if (time() - filemtime($path) > $ttl) return null;
  $raw = file_get_contents($path);
  $j = json_decode($raw ?: '{}', true);
  return is_array($j) ? $j : null;
}
function cache_set(string $path, array $data): void {
  file_put_contents($path, json_encode($data, JSON_UNESCAPED_SLASHES));
}

$categories = cache_get($catsCache, $ttl);
if (!$categories) {
  $r = al_http_get($cfg['network_api'] . '?r=categories');
  $categories = ['ok'=>false];
  if ($r['ok']) {
    $j = json_decode($r['body'] ?: '{}', true);
    if (is_array($j)) $categories = $j;
  }
  cache_set($catsCache, $categories);
}

$listings = cache_get($listCache, $ttl);
if (!$listings) {
  $url = $cfg['network_api'] . '?r=listings&per=' . $per . '&page=' . $page . '&category_id=' . $cat . '&q=' . urlencode($q);
  $r = al_http_get($url);
  $listings = ['ok'=>false];
  if ($r['ok']) {
    $j = json_decode($r['body'] ?: '{}', true);
    if (is_array($j)) $listings = $j;
  }
  cache_set($listCache, $listings);
}

$cats = $categories['categories'] ?? [];
$rows = $listings['listings'] ?? [];
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Auto-Linker Directory</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:#0b0d10;color:#e7e7e7;margin:0}
    a{color:#a7d7ff;text-decoration:none}
    .wrap{max-width:1100px;margin:0 auto;padding:22px}
    .hero{background:linear-gradient(135deg,#121722,#0b0d10);border:1px solid #1f2a3a;border-radius:18px;padding:20px}
    .grid{display:grid;grid-template-columns:1fr;gap:12px;margin-top:14px}
    @media(min-width:860px){.grid{grid-template-columns:1fr 1fr}}
    .card{background:#0f131a;border:1px solid #1f2a3a;border-radius:16px;padding:14px}
    .muted{color:#9aa7b6}
    input,select{width:100%;padding:10px;border-radius:12px;border:1px solid #263548;background:#0f131a;color:#e7e7e7}
    .row{display:grid;grid-template-columns:1fr;gap:10px}
    @media(min-width:860px){.row{grid-template-columns:2fr 1fr 140px}}
    button{padding:10px 14px;border-radius:12px;border:1px solid #2b3b53;background:#142031;color:#fff;font-weight:800;cursor:pointer}
    .pill{display:inline-block;border:1px solid #243349;border-radius:999px;padding:4px 10px;font-size:12px;color:#bcd0e5}
    .pager{display:flex;gap:10px;align-items:center;justify-content:center;margin-top:18px}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="hero">
      <h1 style="margin:0 0 6px 0;">Auto-Linker Directory</h1>
      <div class="muted">
        Powered by <a href="<?=al_h($cfg['network_base'])?>" target="_blank" rel="noopener"><?=al_h($cfg['network_base'])?></a>.
        Sites in this list have verified ownership and keep a visible backlink with anchor text <b>MyBTC.World Auto-Linker</b>.
      </div>

      <div style="margin-top:14px" class="card">
        <form method="get" class="row">
          <div>
            <input name="q" placeholder="Search…" value="<?=al_h($q)?>">
          </div>
          <div>
            <select name="category_id">
              <option value="0">All categories</option>
              <?php foreach($cats as $c): ?>
                <option value="<?= (int)$c['id'] ?>" <?= $cat===(int)$c['id']?'selected':'' ?>><?=al_h($c['name'])?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div><button>Search</button></div>
        </form>
      </div>
    </div>

    <div class="grid">
      <?php foreach($rows as $l): ?>
        <div class="card">
          <div style="font-size:18px;font-weight:900;line-height:1.2">
            <a href="<?=al_h($l['site_url'])?>" target="_blank" rel="noopener"><?=al_h($l['name'])?></a>
          </div>
          <div class="muted" style="margin-top:6px"><?=al_h($l['description'])?></div>
          <div style="margin-top:10px"><span class="pill"><?=al_h($l['category_name'] ?? '')?></span></div>
        </div>
      <?php endforeach; ?>
    </div>

    <div class="pager">
      <?php if ($page>1): ?>
        <a class="pill" href="?<?=al_h(http_build_query(['q'=>$q,'category_id'=>$cat,'page'=>$page-1]))?>">Prev</a>
      <?php endif; ?>
      <span class="muted">Page <?= (int)$page ?></span>
      <?php if (!empty($rows) && count($rows)===$per): ?>
        <a class="pill" href="?<?=al_h(http_build_query(['q'=>$q,'category_id'=>$cat,'page'=>$page+1]))?>">Next</a>
      <?php endif; ?>
    </div>

    <div class="muted" style="margin-top:18px;font-size:13px;text-align:center">
      Admin: <a href="admin/">/admin</a>
    </div>
  </div>
</body>
</html>
